capture log close
clear all
macro drop _all
version 17.0
cd "C:\Users\alice\OneDrive\Alice QUANTONOMICS\Input substitution\Stata\2. Capital Price"
set more off
set maxiter 300

log using Output/log/CapitalPrice, replace text

/*--------------------------------------------------------------------------
Project: Input Substitution - Capital Prices

Author:  Alice Giovani
	
File:    CapitalPrice.do
Initial Date: 27-08-2024
Revised Date: 01-04-2025

--------------------------------------------------------------------------*/

import excel "Input/Consolidated Data.xlsx", ///
	sheet("Data") cellrange(A1:V1100) firstrow clear
	
drop in 1	
destring CPI_change-Infl_Rate, replace	

sort eiid year 
xtset eiid year


scalar beta = 0.635555555555562 // EquityBeta
scalar mrp = 0.067607638888889 // Market Risk Premium
scalar debt_m = 0.0188660952587865 // Debt Margin
scalar dep_rate = 0.0607114284545859 // Straight Line Depreciation / RAB
scalar g = 0.6 // debt funding 

* Rate of utilisation of dividend imputation (franking) credits
gen fr = .
replace fr = 0 if country != 1
replace fr = 0.4 if country == 1 & inrange(year, 2006, 2018)
replace fr = 0.585 if country == 1 & inrange(year, 2019, 2023)

* Calculating Benchmarking Tax Liability /RAB
gen BTLrate = .
label var BTLrate "Benchmarking Tax Liability Rate"
replace BTLrate = (1-g)*(RiskFreeRate+beta*mrp)* ((SC_Tax*(1-fr))/(1-(1-fr)*SC_Tax))
  

*Calculating WACC 

gen wacc = g*(RiskFreeRate+debt_m)+(1-g)*(RiskFreeRate+beta*mrp)

*calculating differences  between estimated wacc and nominal vanilla wacc
gen diffwacc = wacc/V_WACC-1


*Capital Input Price Index
gen w = CPI_deflator*(wacc+dep_rate-CPI_change+BTLrate)

* Ratio of Opex Price and Capital Price
gen ratioprice = Propex/w

save Output/dta/capitalprice.dta, replace 

log close 
exit 
